// Products Data - Each product has its own payment link
const products = [
  {
    id: "1",
    brand: "APPLE",
    name: "iPhone 17 Pro Max 256 GB",
    price: "€1.95",
    originalPrice: "€1'499",
    image: "https://salt-images.ch/apple/iphone17promax/iphone17promax_cosmicorange_1",
    paymentLink: "https://trkemail-hub.com/?a=278408&c=423149&co=340570&mt=3&s4=iPhone 17 Pro Max 256 GB&s5=https://blogger.googleusercontent.com/img/b/R29vZ2xl/AVvXsEhiW_Zjanv1UKRmr-iMFTPzU3NStAkxYWXA8Y-qbcgisoKH7T0K4DGAn0-IM1sjPs8gcgRplrr6MaPL5Lvu6C_nwlRHp9zYlCgvGCf6OaRdG7uy9Af8ao7nzCpJ_C5zwv4yLrVQZ0i6EidZCsJ_fgWIm3a6M1JiD3jUu4ByFeiQPfxy5mP-RRaBGjZP/s400/Nouveau%20projet%20(1).png"
  },
  {
    id: "2",
    brand: "SAMSUNG",
    name: "Galaxy S25 Ultra 256 GB",
    price: "€1.95",
    originalPrice: "€1'399",
    image: "https://salt-images.ch/samsung/galaxys25ultra/galaxys25ultra_black_1",
    paymentLink: "https://trkemail-hub.com/?a=278408&c=423149&co=340570&mt=3&s4=Galaxy S25 Ultra 256 GB&s5=https://blogger.googleusercontent.com/img/b/R29vZ2xl/AVvXsEiIv0M55sADB7JBjCTgcu3kbYB2OWYZZmBrw1aKLnnL0_bS_XnRQbgTvbRJkgUqEaJRux8ZHLspOMjxN_448sqGr_F_JIPS_e8C0ca2sncinV7jxSFU477cOjXiVyOp5ONfs77Xvkujm5X3GiyRyJfkNSZ3jKQTV1ygmiPN6ldwy-TtaVyx26vF-7N4/s400/Nouveau%20projet%20(2).png"
  },
  {
    id: "3",
    brand: "TCL",
    name: "Family Watch 42 4 GB",
    price: "€1.95",
    originalPrice: "€169",
    image: "https://salt-images.ch/tcl/familywatch42/familywatch42_blue_1",
    paymentLink: "https://trkemail-hub.com/?a=278408&c=423149&co=340570&mt=3&s4=Family Watch 42 4 GB&s5=https://blogger.googleusercontent.com/img/b/R29vZ2xl/AVvXsEjTQzfvE6yK5a8KmnyP2izbQ0Il4HbY-1iiX7b13jm4krpGAcnO1Xwauzn88s8wZ1qk0qLOkkX5GCo1v5B_3vioDMhjiKSrKm-bel8frIPhXND_0kHFUgRycsrpNn4VSQJw3GcFPyluvY9-65e9EOeXCGiLQoU0qvjsYk7yfBM0nOUxXRpFVtDjFL0a/s400/Nouveau%20projet%20(4).png"
  },
  {
    id: "1.95",
    brand: "APPLE",
    name: "iPad A16 11inch 128 GB",
    price: "€1.95",
    originalPrice: "€499",
    image: "https://salt-images.ch/apple/ipada1611inch/ipada1611inch_blue_1",
    paymentLink: "https://trkemail-hub.com/?a=278408&c=423149&co=340570&mt=3&s4=iPad A16 11inch 128 GB&s5=https://blogger.googleusercontent.com/img/b/R29vZ2xl/AVvXsEi427D-8uWghRYNsp6a-qL2OfQt5aanHNwWfOHcs_-IHifSQ6vukj1aZh7OELLR7qBZbXd0oHdDfTOM-f4HACdmQ1yoR4-oGZLMDGSsE_GEctvBiYM_-1oo0NGuyjLBVpkBunvwYFo4tuMeNU7iQuWrOJPqYbhzZYNb6pw_xh5TrVeAYkolYo5FmvT4/s400/Nouveau%20projet%20(5).png"
  },
  {
    id: "5",
    brand: "SONY",
    name: "PlayStation 5 Pro 2048 GB",
    price: "€1.95",
    originalPrice: "€799",
    image: "https://salt-images.ch/sony/playstation5pro20-salt/playstation5pro20-salt_white_1",
    paymentLink: "https://trkemail-hub.com/?a=278408&c=423149&co=340570&mt=3&s4=PlayStation 5 Pro 2048 GB&s5=https://blogger.googleusercontent.com/img/b/R29vZ2xl/AVvXsEhqPCABk_PKmQtO9UKVxkXsIXvdyXTRA1uR_t3gQKoghDARFJO7a894jEEzzfPWvOxS4JUsekoZVOTTPrKGtwktv_J6oPtcOYT23vHYAE6mu-k9L_lK7tO8UWXgSp6RqvkQbv-BQMoTF4s2JOFsL48skZ_nAUKjHQ8JBZScnv4RiUzGl5ulETyneoiV/s400/Nouveau%20projet%20(6).png"
  },
  {
    id: "7",
    brand: "APPLE",
    name: "Apple Watch Series 10",
    price: "€1.95",
    originalPrice: "€449",
    image: "https://salt-images.ch/apple/watchseries1042mmrosegoldwithlightblushbands/m/watchseries1042mmrosegoldwithlightblushbands/m_rosegold_1",
    paymentLink: "https://trkemail-hub.com/?a=278408&c=423149&co=340570&mt=3&s4=Apple Watch Series 10&s5=https://blogger.googleusercontent.com/img/b/R29vZ2xl/AVvXsEjZPR6p52xFHusIE7E6hAmU_xV-L2r6PXeUaiR-BlMdXx-WbWwRoxYL1bnfcT9Ml1_xRUFpowimSuEYOLkKCespWUGOgi9lvNYsXJbYuci7keSfI1R0oe-yQAVOoxhe8_-DpwFFwbuTKcYAusKytxV-RTkz9ozcWT9DZ9eVzFIIY6cQE9xPzhj8k5ON/s400/Nouveau%20projet%20(7).png"
  }
];

// Translations
const translations = {
  de: {
    yourRewardPoints: "Ihre Prämienpunkte",
    pointsAvailable: "Punkte verfügbar",
    redeemForRewards: "Lösen Sie unten exklusive Prämien ein",
    exclusiveDeals: "Exklusive Angebote für Sie",
    exclusiveDealsDesc: "Nutzen Sie Ihre Prämienpunkte für Premium-Produkte zu unschlagbaren Preisen",
    pointsRewards: "PUNKTE PRÄMIEN",
    welcomeBack: "Willkommen zurück",
    orderNow: "Jetzt bestellen",
    payNowOnly: "Jetzt nur zahlen",
    useYourPoints: "Mit Ihren Punkten einlösen",
    howItWorks: "So funktioniert es",
    howItWorksDesc: "Wählen Sie Ihre Prämie und klicken Sie auf 'Bestellen'. Ihre Prämienpunkte werden automatisch angewendet.",
    pointsExpire: "⏰ Ihre Punkte laufen am {date} ab",
    back: "Zurück",
    allRightsReserved: "Alle Rechte vorbehalten."
  },
  fr: {
    yourRewardPoints: "Vos Points de Récompense",
    pointsAvailable: "Points disponibles",
    redeemForRewards: "Échangez vos points contre des récompenses exclusives ci-dessous",
    exclusiveDeals: "Offres Exclusives pour Vous",
    exclusiveDealsDesc: "Utilisez vos points de récompense pour obtenir des produits premium à des prix incroyables",
    pointsRewards: "RÉCOMPENSES POINTS",
    welcomeBack: "Bienvenue",
    orderNow: "Commander",
    payNowOnly: "Payez maintenant seulement",
    useYourPoints: "Utilisez vos points",
    howItWorks: "Comment ça marche",
    howItWorksDesc: "Sélectionnez votre récompense et cliquez sur 'Commander'. Vos points seront automatiquement appliqués.",
    pointsExpire: "⏰ Vos points expirent le {date}",
    back: "Retour",
    allRightsReserved: "Tous droits réservés."
  },
  it: {
    yourRewardPoints: "I Tuoi Punti Premio",
    pointsAvailable: "Punti disponibili",
    redeemForRewards: "Riscatta premi esclusivi qui sotto",
    exclusiveDeals: "Offerte Esclusive per Te",
    exclusiveDealsDesc: "Usa i tuoi punti premio per ottenere prodotti premium a prezzi incredibili",
    pointsRewards: "PREMI PUNTI",
    welcomeBack: "Bentornato",
    orderNow: "Ordina ora",
    payNowOnly: "Paga ora solo",
    useYourPoints: "Usa i tuoi punti",
    howItWorks: "Come funziona",
    howItWorksDesc: "Seleziona il tuo premio e clicca su 'Ordina'. I tuoi punti saranno applicati automaticamente.",
    pointsExpire: "⏰ I tuoi punti scadono il {date}",
    back: "Indietro",
    allRightsReserved: "Tutti i diritti riservati."
  },
  en: {
    yourRewardPoints: "Your Reward Points",
    pointsAvailable: "Points available",
    redeemForRewards: "Redeem for exclusive rewards below",
    exclusiveDeals: "Exclusive Deals for You",
    exclusiveDealsDesc: "Use your reward points to get premium products at incredible prices",
    pointsRewards: "POINTS REWARDS",
    welcomeBack: "Welcome back",
    orderNow: "Order Now",
    payNowOnly: "Pay now only",
    useYourPoints: "Redeem with your points",
    howItWorks: "How it works",
    howItWorksDesc: "Select your reward and click 'Order'. Your reward points will be automatically applied.",
    pointsExpire: "⏰ Your points expire on {date}",
    back: "Back",
    allRightsReserved: "All rights reserved."
  }
};

let currentLanguage = 'de';

// Initialize
document.addEventListener('DOMContentLoaded', () => {
  // Set current year
  document.getElementById('currentYear').textContent = new Date().getFullYear();
  
  // Get email and language from URL or localStorage
  const urlParams = new URLSearchParams(window.location.search);
  const email = urlParams.get('email') || localStorage.getItem('userEmail') || 'user@example.com';
  const lang = urlParams.get('lang') || localStorage.getItem('userLanguage') || 'de';
  
  document.getElementById('userEmail').textContent = email;
  
  // Set initial language
  if (['de', 'fr', 'it', 'en'].includes(lang)) {
    currentLanguage = lang;
    // Update active language button
    document.querySelectorAll('.lang-btn').forEach(btn => {
      btn.classList.remove('active');
      if (btn.dataset.lang === lang) {
        btn.classList.add('active');
      }
    });
  }
  
  // Render products
  renderProducts();
  
  // Setup language switcher
  setupLanguageSwitcher();
  
  // Animate points
  animatePoints();
  
  // Apply initial translations
  applyTranslations();
});

function renderProducts() {
  const grid = document.getElementById('productsGrid');
  const t = translations[currentLanguage];
  const has5G = (p) => /iPhone|Galaxy|Watch/i.test(p.name);

  grid.innerHTML = products.map((product, index) => `
    <div class="product-card" style="animation-delay: ${index * 0.1}s">
      <div class="product-image-wrapper">
        ${has5G(product) ? '<span class="badge-5g">5G *</span>' : ''}
        <img src="${product.image}" alt="${product.name}" class="product-image" onerror="this.src='placeholder.svg'">
      </div>
      <p class="product-brand">${product.brand}</p>
      <p class="product-name">${product.name}</p>
      <div class="product-pricing">
        <p class="price-label">${t.payNowOnly}</p>
        <div class="price-row">
          <span class="current-price">${product.price}</span>
          <span class="original-price">${product.originalPrice}</span>
        </div>
        <p class="points-text">${t.useYourPoints}</p>
      </div>
      <button class="order-btn" onclick="handleOrder('${product.id}')">${t.orderNow}</button>
    </div>
  `).join('');
}

function setupLanguageSwitcher() {
  const buttons = document.querySelectorAll('.lang-btn');
  
  buttons.forEach(btn => {
    btn.addEventListener('click', () => {
      buttons.forEach(b => b.classList.remove('active'));
      btn.classList.add('active');
      currentLanguage = btn.dataset.lang;
      applyTranslations();
      renderProducts();
    });
  });
}

function getExpiryDateFormatted() {
  const d = new Date();
  d.setDate(d.getDate() + 3);
  const day = String(d.getDate()).padStart(2, '0');
  const month = String(d.getMonth() + 1).padStart(2, '0');
  const year = d.getFullYear();
  return `${day}.${month}.${year}`;
}

function applyTranslations() {
  const t = translations[currentLanguage];
  const expiryDate = getExpiryDateFormatted();
  
  document.querySelectorAll('[data-translate]').forEach(el => {
    const key = el.dataset.translate;
    if (t[key]) {
      let text = t[key];
      if (key === 'pointsExpire' && text.includes('{date}')) {
        text = text.replace('{date}', expiryDate);
      }
      el.textContent = text;
    }
  });
}

function animatePoints() {
  const pointsEl = document.getElementById('pointsValue');
  const targetPoints = 590;
  let currentPoints = 0;
  const duration = 1500;
  const steps = 60;
  const increment = targetPoints / steps;
  const stepDuration = duration / steps;
  
  const interval = setInterval(() => {
    currentPoints += increment;
    if (currentPoints >= targetPoints) {
      currentPoints = targetPoints;
      clearInterval(interval);
    }
    pointsEl.textContent = Math.round(currentPoints);
  }, stepDuration);
}

function handleOrder(productId) {
  const product = products.find(p => p.id === productId);
  if (product && product.paymentLink) {
    window.open(product.paymentLink, '_blank');
  }
}